#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2004, 2005, 2006, 2007 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching  <crunchy@bitkipper.net>

"""
test programm for signals implementation
"""

import time

import mock
import pytest

import notifier
import notifier.signals as signals


class SignalTest(signals.Provider):
	def __init__(self):
		signals.Provider.__init__(self)
		self.signal_new('test-signal')


@pytest.fixture(scope='module')
def global_data():
	return {'test': SignalTest()}


signals.new('test-signal')


def test_signals_module():
	timer_cb = mock.Mock()
	signal_cb = mock.Mock()
	notifier.init(notifier.GENERIC)
	signals.connect(
		'test-signal', notifier.Callback(signal_cb, 1, 2, 'global signal'))
	notifier.timer_add(2000, notifier.Callback(timer_cb, 7))
	for i in range(3):
		notifier.step()
		time.sleep(1)


def test_signals_obj(global_data):
	timer_cb = mock.Mock()
	signal_cb = mock.Mock()
	notifier.init(notifier.GENERIC)
	global_data['test'].signal_connect(
		'test-signal', notifier.Callback(signal_cb, 1, 2, 'SignalTest signal'))
	notifier.timer_add(2000, notifier.Callback(timer_cb, 7))
	for i in range(3):
		notifier.step()
		time.sleep(1)


def test_unknown_signal_error():
	cb = mock.Mock()
	with pytest.raises(signals.UnknownSignalError):
		signals.connect("clicked2", cb)
