#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2004, 2005, 2006, 2007 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching  <crunchy@bitkipper.net>

"""
test programm for generic notifier implementation
"""

import time

import notifier
import notifier.popen


def test_generic():
	cb_results = {}

	def find_result(pid, status, result):
		cb_results['pid'] = pid
		cb_results['status'] = status
		cb_results['result'] = result

	notifier.init(notifier.GENERIC)
	# find_result = mock.Mock()

	cmd = '/bin/sh -c "/bin/sleep 2 && seq 10"'
	proc = notifier.popen.RunIt(cmd, stdout=True)
	proc.signal_connect('finished', find_result)
	pid = proc.start()
	assert pid > 0
	for _i in range(3):
		notifier.step()
		time.sleep(1)
	assert cb_results['pid'] == pid
	assert cb_results['status'] == 0
	assert len(cb_results['result']) >= 10
