#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2008 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching <crunchy@bitkipper.net>

"""
Simple test program for the Twisted notifier.
"""

from __future__ import print_function

import os
import sys
import time

import notifier

# import twisted


notifier.init(notifier.TWISTED)

_stdout = os.fdopen(sys.stdout.fileno(), 'w', 0)

# notifier-timer testfunction


def timer_test():
	print("\ntimer_test")
	# notifier.dispatcher_add( notifier.Callback( dispatcher_test, 1, 2, 3 ) )
	return True


def timer_once():
	print("\njust once")
	return False


def dispatcher_test(a, b, c):
	global _stdout
	_stdout.write('.')
	time.sleep(0.02)
	_stdout.write('\033[1D*')
	return True


def _stdin(fd):
	print('read: %s' % os.read(fd, 512))
	notifier.socket_remove(0)
	return False


notifier.socket_add(0, _stdin)
notifier.timer_add(1400, notifier.Callback(timer_once))
notifier.timer_add(4000, notifier.Callback(timer_test))
notifier.dispatcher_add(notifier.Callback(dispatcher_test, 1, 2, 3))
notifier.loop()
