#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2004, 2005, 2006, 2007 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching <crunchy@bitkipper.net>

"""
test programm for the QT3 and QT4 notifier
"""

from __future__ import print_function

import sys

import PyQt5.Qt as qt

import notifier


class QTestApp(qt.QCoreApplication):
	def __init__(self):
		qt.QCoreApplication.__init__(self, sys.argv)

		self.timer_id = notifier.timer_add(1000, self.timerTest)
		self.dispatch_it = 10

	def recvQuit(self, mmsg, data=None):
		self.quit()

	def timerTest(self):
		print('tick')
		return True

	def _dispatch(self):
		print('dispatch')
		self.dispatch_it -= 1
		return self.dispatch_it > 0


class MyThread(qt.QThread):
	def run(self):
		self._timer = notifier.timer_add(2000, self.tick)

		notifier.loop()
		# import time
		# while True:
		# 	print 'going to sleep'
		# 	time.sleep( 1 )
		# 	# in order to process events in this thread
		# 	qt.QCoreApplication.processEvents()
		# 	print 'wake up'

	def tick(self):
		print('tick my thread')
		return True


if __name__ == '__main__':
	notifier.init(notifier.QT)
	app = QTestApp()

	mt = MyThread()
	mt.start()

	#notifier.dispatcher_add( app._dispatch )
	print('exit code: %d' % notifier.loop())
