#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2004, 2005, 2006, 2007 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching  <crunchy@bitkipper.net>

"""
test programm for generic notifier implementation
"""

from __future__ import print_function

import time

import notifier


def timeout(data):
    print('timeout', time.time())
    print('  data    :', data)

    return True


def zero(data):
    print('timeout', time.time())
    print('  data    :', data)

    return True


def dispatch(data):
    #print 'dispatch', data
    return True


# when no argument is given to init default is GENERIC
notifier.init(notifier.GENERIC, recursive_depth=5)
notifier.timer_add(1000, notifier.Callback(timeout, 'hello'))
#notifier.timer_add( 0, notifier.Callback( zero, 'hello' ) )
notifier.dispatcher_add(notifier.Callback(dispatch, 'hello'))
#notifier.dispatcher_add( notifier.Callback( dispatch, 'hello' ), False )

notifier.loop()
