#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2005, 2006 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching	<crunchy@bitkipper.net>

"""
signal example of asynchron events
"""

from __future__ import print_function

import notifier
import notifier.signals as signals


def _wait_for_click():
	print("clicked")


def _wait_for_movement(optional=None):
	print("optional:", optional)


def _emitting():
	signals.emit("clicked")
	# return True


if __name__ == '__main__':
	notifier.init(notifier.GENERIC)

	signals.new("clicked")
	try:
		signals.connect("clicked2", _wait_for_click)
	except signals.UnknownSignalError as e:
		print('Exception:', e)
	if not signals.exists('clicked3'):
		print("signal 'clicked3' does not exist")
	signals.connect('clicked', _wait_for_click)
	signals.connect('clicked', notifier.Callback(_wait_for_movement, 'optional something'))
	notifier.timer_add(3000, _emitting)

	notifier.loop()
