#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2006 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching <crunchy@bitkipper.net>

"""
an example demonstrating the process handler class RunIt
"""

from __future__ import print_function

import notifier
import notifier.popen


def tick():
	print('tick')
	cmd = ['ps', 'h', '-eo', 'pcpu,vsize,rssize,pmem,user,pid,command', '--sort=-pcpu']
	proc = notifier.popen.Process(cmd, stdout=True)
	proc.signal_connect('stdout', find_result)
	proc.start()

	return True


def find_result(pid, result):
	for line in result:
		print(line)


if __name__ == '__main__':
	notifier.init(notifier.GENERIC)

	notifier.timer_add(5000, tick)

	notifier.loop()
